<?php

use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\UserAuthController;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
*/
Route::prefix('user')->group(function () {
    Route::post('/register', [UserAuthController::class, 'register']);
    Route::post('/login', [UserAuthController::class, 'login']);
    Route::post('/send-otp', [UserAuthController::class, 'sendOtp']);
    Route::post('/verify-otp', [UserAuthController::class, 'verifyOtp']);
    Route::post('/reset-password', [UserAuthController::class, 'resetPassword']);

    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/profile', [UserAuthController::class, 'profile']);
        Route::post('/profile', [UserAuthController::class, 'updateProfile']);
        Route::post('/logout', [UserAuthController::class, 'logout']);
        // Add more protected user routes here
    });
});

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
*/
Route::prefix('admin')->group(function () {
    Route::post('/register', [AdminAuthController::class, 'register']);
    Route::post('/login', [AdminAuthController::class, 'login']);
    Route::post('/send-otp', [AdminAuthController::class, 'sendOtp']);
    Route::post('/verify-otp', [AdminAuthController::class, 'verifyOtp']);
    Route::post('/reset-password', [AdminAuthController::class, 'resetPassword']);

    Route::middleware('auth:sanctum')->group(function () {

        Route::get('/profile', [AdminAuthController::class, 'profile']);
        Route::post('/profile', [AdminAuthController::class, 'updateProfile']);
        Route::post('/logout', [AdminAuthController::class, 'logout']);

        // Permission-based routes
        Route::middleware('admin.permission:create_user')->get('/create-user', function () {
            return response()->json(['message' => 'You have create_user permission']);
        });

        Route::middleware('admin.permission:delete_user')->delete('/delete-user', function () {
            return response()->json(['message' => 'You have delete_user permission']);
        });

        // Add more admin protected routes here
    });
});


