<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use Symfony\Component\HttpFoundation\Response;

class CheckTokenExpiry
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     *
     */

    protected $guards = ['admin', 'user'];


    public function handle(Request $request, Closure $next): Response
    {
        foreach ($this->guards as $guard) {
            if ($user = Auth::guard($guard)->user()) {
                // Attach the authenticated user to request
                $request->merge(['auth_user' => $user]);
                $request->attributes->set('auth_type', $guard);
                return $next($request);
            }
        }

        return response()->json([
            'success' => false,
            'message' => 'Unauthenticated.',
        ], 401);

    }

}
