<?php

use App\Http\Middleware\CheckAdminPermission;
use App\Http\Middleware\CheckTokenExpiry;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->api(prepend: [
            \Illuminate\Http\Middleware\HandleCors::class,
        ]);
        $middleware->alias([
            'check.token' => CheckTokenExpiry::class,
            'admin.permission' => CheckAdminPermission::class,
            // you can add more route middlewares here
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {

    })->create();
