<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('sku');
            $table->string('barcode')->nullable();
            $table->string('image')->nullable();
            $table->string('cat_id')->nullable();
            $table->string('subcat_id')->nullable();
            $table->string('brand_id')->nullable();
            $table->string('unit_id')->nullable();
            $table->string('color_id')->nullable();
            $table->string('price')->nullable();
            $table->string('offer_price')->nullable();
            $table->string('stock')->nullable();
            $table->text('description')->nullable();
            $table->string('alert_quantity')->nullable();
            $table->string('weight')->nullable();
            $table->string('size_id')->nullable();
            $table->string('material')->nullable();
            $table->string('origin')->nullable();
            $table->text('gallery_images')->nullable();
            $table->enum('extra_status', ['hot','featured','spotlight','popular','best_selling'])->nullable()->default(null);
            $table->enum('status', ['active','inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
