<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class BrandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $brands = [
            [
                'name' => 'Apple',
                'logo' => 'brands/brand-1.jpg',
                'description' => 'A leading technology brand known for innovation.',
                'status' => 'active',
            ],
            [
                'name' => 'Samsung',
                'logo' => 'brands/brand-2.jpg',
                'description' => 'A major electronics and consumer brand worldwide.',
                'status' => 'active',
            ],
            [
                'name' => 'Sony',
                'logo' => 'brands/brand-3.jpg',
                'description' => 'Famous for its high quality consumer electronics.',
                'status' => 'active',
            ],
            [
                'name' => 'Nike',
                'logo' => 'brands/brand-4.jpg',
                'description' => 'A global leader in sports footwear and apparel.',
                'status' => 'active',
            ],
            [
                'name' => 'Adidas',
                'logo' => 'brands/brand-5.jpg',
                'description' => 'Popular brand for shoes, clothing, and accessories.',
                'status' => 'active',
            ],
            [
                'name' => 'Microsoft',
                'logo' => 'brands/brand-6.jpg',
                'description' => 'Renowned for its software and computer electronics.',
                'status' => 'active',
            ],
            [
                'name' => 'HP',
                'logo' => 'brands/brand-7.jpg',
                'description' => 'A top provider of computers and printers.',
                'status' => 'active',
            ],
            [
                'name' => 'Lenovo',
                'logo' => 'brands/brand-8.jpg',
                'description' => 'Known for innovative laptops and tech solutions.',
                'status' => 'active',
            ],
            [
                'name' => 'Gucci',
                'logo' => 'brands/brand-9.jpg',
                'description' => 'A luxury fashion brand with global reach.',
                'status' => 'active',
            ],
            [
                'name' => 'BMW',
                'logo' => 'brands/brand-10.jpg',
                'description' => 'Leading automobile manufacturer of luxury vehicles.',
                'status' => 'active',
            ],
        ];

        foreach ($brands as &$brand) {
            $brand['created_at'] = Carbon::now();
            $brand['updated_at'] = Carbon::now();
        }
        unset($brand);

        DB::table('brands')->insert($brands);
    }
}
