<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ContactSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $contacts = [
            [
                'name' => 'John Doe',
                'email' => 'john.doe@example.com',
                'subject' => 'Product Inquiry',
                'message' => 'Interested in your products.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Jane Smith',
                'email' => 'jane.smith@example.com',
                'subject' => 'Callback Request',
                'message' => 'Requesting a callback.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Alice Brown',
                'email' => 'alice.brown@example.com',
                'subject' => 'Shipping Information',
                'message' => 'Need information about shipping.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Bob Johnson',
                'email' => 'bob.johnson@example.com',
                'subject' => 'Service Feedback',
                'message' => 'Feedback on your service.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Sara Lee',
                'email' => 'sara.lee@example.com',
                'subject' => 'Wholesale Pricing',
                'message' => 'Interested in wholesale prices.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Michael King',
                'email' => 'michael.king@example.com',
                'subject' => 'Bulk Order Inquiry',
                'message' => 'Inquiry about bulk order discounts.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Rachel Green',
                'email' => 'rachel.green@example.com',
                'subject' => 'Delivery Time',
                'message' => 'How long does delivery take?',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Chris Evans',
                'email' => 'chris.evans@example.com',
                'subject' => 'Warranty Question',
                'message' => 'Question concerning warranties.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Emma White',
                'email' => 'emma.white@example.com',
                'subject' => 'Quotation Request',
                'message' => 'Request for quotation.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'David Black',
                'email' => 'david.black@example.com',
                'subject' => 'Order Support',
                'message' => 'Support needed for order.',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        DB::table('contacts')->insert($contacts);
    }
}
