<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Customer;
use Carbon\Carbon;

class CustomerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $customers = [
            [
                'name' => 'John Doe',
                'phone' => '+1-555-111-1111',
                'address' => '102 Main St, New York, NY',
                'purchase_items' => 2,
                'purchase_amount' => 99.99,
                'total_purchase_items' => 10,
                'total_purchase_amount' => 1500.50,
                'earned_points' => 105,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Jane Smith',
                'phone' => '+1-555-222-2222',
                'address' => '203 Market Ave, Los Angeles, CA',
                'purchase_items' => 1,
                'purchase_amount' => 23.50,
                'total_purchase_items' => 5,
                'total_purchase_amount' => 300.00,
                'earned_points' => 60,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Alice Brown',
                'phone' => '+1-555-333-3333',
                'address' => '304 Oak St, Chicago, IL',
                'purchase_items' => 0,
                'purchase_amount' => 0.00,
                'total_purchase_items' => 3,
                'total_purchase_amount' => 120.75,
                'earned_points' => 20,
                'status' => 'inactive',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Bob Johnson',
                'phone' => '+1-555-444-4444',
                'address' => '405 Pine Ave, Houston, TX',
                'purchase_items' => 4,
                'purchase_amount' => 199.99,
                'total_purchase_items' => 12,
                'total_purchase_amount' => 2200.00,
                'earned_points' => 225,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Sara Lee',
                'phone' => '+1-555-555-5555',
                'address' => '506 Cedar Ave, Miami, FL',
                'purchase_items' => 2,
                'purchase_amount' => 49.90,
                'total_purchase_items' => 6,
                'total_purchase_amount' => 400.99,
                'earned_points' => 70,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Michael King',
                'phone' => '+1-555-666-6666',
                'address' => '607 Spruce Dr, Boston, MA',
                'purchase_items' => 3,
                'purchase_amount' => 135.25,
                'total_purchase_items' => 8,
                'total_purchase_amount' => 640.10,
                'earned_points' => 80,
                'status' => 'inactive',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Nancy Clark',
                'phone' => '+1-555-777-7777',
                'address' => '708 Birch Ln, Seattle, WA',
                'purchase_items' => 6,
                'purchase_amount' => 289.90,
                'total_purchase_items' => 20,
                'total_purchase_amount' => 3300.55,
                'earned_points' => 320,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'David Miller',
                'phone' => '+1-555-888-8888',
                'address' => '809 Willow Ct, Denver, CO',
                'purchase_items' => 5,
                'purchase_amount' => 160.00,
                'total_purchase_items' => 15,
                'total_purchase_amount' => 1950.60,
                'earned_points' => 140,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Emma Watson',
                'phone' => '+1-555-999-9999',
                'address' => '910 Maple St, Austin, TX',
                'purchase_items' => 1,
                'purchase_amount' => 19.80,
                'total_purchase_items' => 2,
                'total_purchase_amount' => 60.20,
                'earned_points' => 10,
                'status' => 'inactive',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'James Anderson',
                'phone' => '+1-555-000-0000',
                'address' => '101 Aspen Blvd, Portland, OR',
                'purchase_items' => 8,
                'purchase_amount' => 399.99,
                'total_purchase_items' => 30,
                'total_purchase_amount' => 6000.00,
                'earned_points' => 570,
                'status' => 'active',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]
        ];

        foreach ($customers as $customer) {
            Customer::create($customer);
        }
    }
}
