<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Purchase;
use Carbon\Carbon;

class PurchaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $purchases = [
            [
                'purchase_id'   => 'PUR-20240101-0001',
                'supplier_id'   => 1,
                'products'      => json_encode([
                    ['product_id' => 1, 'quantity' => 2, 'unit_price' => 120.50, 'subtotal' => 241.00],
                    ['product_id' => 3, 'quantity' => 4, 'unit_price' => 50.75, 'subtotal' => 203.00],
                ]),
                'total_amount'  => 444.00,
                'vat'           => 20.00,
                'discount'      => 15.00,
                'grand_total'   => 449.00,
                'paid'          => 250.00,
                'due'           => 199.00,
                'paid_by'       => 'cash',
                'purchase_date' => '2024-01-01',
                'notes'         => 'Initial stock purchase.',
            ],
            [
                'purchase_id'   => 'PUR-20240103-0002',
                'supplier_id'   => 2,
                'products'      => json_encode([
                    ['product_id' => 2, 'quantity' => 1, 'unit_price' => 80.00, 'subtotal' => 80.00],
                    ['product_id' => 4, 'quantity' => 5, 'unit_price' => 35.20, 'subtotal' => 176.00],
                ]),
                'total_amount'  => 256.00,
                'vat'           => 12.80,
                'discount'      => 6.00,
                'grand_total'   => 262.80,
                'paid'          => 100.00,
                'due'           => 162.80,
                'paid_by'       => 'credit',
                'purchase_date' => '2024-01-03',
                'notes'         => 'Monthly supplier order.',
            ],
            [
                'purchase_id'   => 'PUR-20240105-0003',
                'supplier_id'   => 3,
                'products'      => json_encode([
                    ['product_id' => 5, 'quantity' => 3, 'unit_price' => 64.99, 'subtotal' => 194.97],
                    ['product_id' => 7, 'quantity' => 2, 'unit_price' => 150.00, 'subtotal' => 300.00],
                ]),
                'total_amount'  => 494.97,
                'vat'           => 22.50,
                'discount'      => 18.50,
                'grand_total'   => 498.97,
                'paid'          => 350.00,
                'due'           => 148.97,
                'paid_by'       => 'bank transfer',
                'purchase_date' => '2024-01-05',
                'notes'         => 'Restock after holiday sales.',
            ],
            [
                'purchase_id'   => 'PUR-20240108-0004',
                'supplier_id'   => 4,
                'products'      => json_encode([
                    ['product_id' => 6, 'quantity' => 6, 'unit_price' => 25.00, 'subtotal' => 150.00],
                ]),
                'total_amount'  => 150.00,
                'vat'           => 7.50,
                'discount'      => 2.50,
                'grand_total'   => 155.00,
                'paid'          => 155.00,
                'due'           => 0.00,
                'paid_by'       => 'cash',
                'purchase_date' => '2024-01-08',
                'notes'         => null,
            ],
            [
                'purchase_id'   => 'PUR-20240110-0005',
                'supplier_id'   => 5,
                'products'      => json_encode([
                    ['product_id' => 8, 'quantity' => 10, 'unit_price' => 15.50, 'subtotal' => 155.00],
                    ['product_id' => 4, 'quantity' => 2, 'unit_price' => 37.00, 'subtotal' => 74.00],
                ]),
                'total_amount'  => 229.00,
                'vat'           => 9.20,
                'discount'      => 4.00,
                'grand_total'   => 234.20,
                'paid'          => 234.20,
                'due'           => 0.00,
                'paid_by'       => 'bank transfer',
                'purchase_date' => '2024-01-10',
                'notes'         => 'Cleared on delivery.',
            ],
            [
                'purchase_id'   => 'PUR-20240113-0006',
                'supplier_id'   => 1,
                'products'      => json_encode([
                    ['product_id' => 2, 'quantity' => 7, 'unit_price' => 11.45, 'subtotal' => 80.15],
                ]),
                'total_amount'  => 80.15,
                'vat'           => 4.01,
                'discount'      => 1.00,
                'grand_total'   => 83.16,
                'paid'          => 40.00,
                'due'           => 43.16,
                'paid_by'       => 'cash',
                'purchase_date' => '2024-01-13',
                'notes'         => 'Cash partial payment.',
            ],
            [
                'purchase_id'   => 'PUR-20240115-0007',
                'supplier_id'   => 6,
                'products'      => json_encode([
                    ['product_id' => 10, 'quantity' => 1, 'unit_price' => 499.99, 'subtotal' => 499.99],
                ]),
                'total_amount'  => 499.99,
                'vat'           => 25.00,
                'discount'      => 19.99,
                'grand_total'   => 505.00,
                'paid'          => 200.00,
                'due'           => 305.00,
                'paid_by'       => 'credit',
                'purchase_date' => '2024-01-15',
                'notes'         => 'Installment.',
            ],
            [
                'purchase_id'   => 'PUR-20240117-0008',
                'supplier_id'   => 3,
                'products'      => json_encode([
                    ['product_id' => 9, 'quantity' => 8, 'unit_price' => 17.50, 'subtotal' => 140.00],
                    ['product_id' => 8, 'quantity' => 2, 'unit_price' => 15.00, 'subtotal' => 30.00],
                ]),
                'total_amount'  => 170.00,
                'vat'           => 8.50,
                'discount'      => 5.00,
                'grand_total'   => 173.50,
                'paid'          => 173.50,
                'due'           => 0.00,
                'paid_by'       => 'cash',
                'purchase_date' => '2024-01-17',
                'notes'         => null,
            ],
            [
                'purchase_id'   => 'PUR-20240121-0009',
                'supplier_id'   => 7,
                'products'      => json_encode([
                    ['product_id' => 3, 'quantity' => 5, 'unit_price' => 85.00, 'subtotal' => 425.00],
                ]),
                'total_amount'  => 425.00,
                'vat'           => 17.00,
                'discount'      => 8.00,
                'grand_total'   => 434.00,
                'paid'          => 434.00,
                'due'           => 0.00,
                'paid_by'       => 'bank transfer',
                'purchase_date' => '2024-01-21',
                'notes'         => 'Bulk special order.',
            ],
            [
                'purchase_id'   => 'PUR-20240125-0010',
                'supplier_id'   => 8,
                'products'      => json_encode([
                    ['product_id' => 6, 'quantity' => 2, 'unit_price' => 100.00, 'subtotal' => 200.00],
                    ['product_id' => 1, 'quantity' => 9, 'unit_price' => 12.00, 'subtotal' => 108.00],
                ]),
                'total_amount'  => 308.00,
                'vat'           => 13.00,
                'discount'      => 5.00,
                'grand_total'   => 316.00,
                'paid'          => 150.00,
                'due'           => 166.00,
                'paid_by'       => 'credit',
                'purchase_date' => '2024-01-25',
                'notes'         => 'Final January supply.',
            ],
        ];

        foreach ($purchases as $purchase) {
            Purchase::create($purchase);
        }
    }
}
