<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Sales;
use Carbon\Carbon;

class SalesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $salesData = [
            [
                'sales_id' => 'SAL-20240101-0001',
                'customer_name' => 'John Doe',
                'customer_phone' => '+1-555-123-4567',
                'products' => json_encode([
                    ['product_id' => 1, 'name' => 'Ultra Phone X1', 'quantity' => 2, 'price' => 499, 'subtotal' => 998],
                    ['product_id' => 2, 'name' => 'Pro Bluetooth Headphones', 'quantity' => 1, 'price' => 129, 'subtotal' => 129],
                ]),
                'total_amount' => 1127,
                'vat' => 56.35,
                'discount' => 30,
                'grand_total' => 1153.35,
                'paid_by' => 'cash',
                'created_at' => Carbon::parse('2024-01-01'),
                'updated_at' => Carbon::parse('2024-01-01'),
            ],
            [
                'sales_id' => 'SAL-20240102-0002',
                'customer_name' => 'Jane Smith',
                'customer_phone' => '+1-555-555-1111',
                'products' => json_encode([
                    ['product_id' => 3, 'name' => 'Wireless Charger', 'quantity' => 3, 'price' => 35.50, 'subtotal' => 106.5],
                ]),
                'total_amount' => 106.5,
                'vat' => 8.75,
                'discount' => 5,
                'grand_total' => 110.25,
                'paid_by' => 'card',
                'created_at' => Carbon::parse('2024-01-02'),
                'updated_at' => Carbon::parse('2024-01-02'),
            ],
            [
                'sales_id' => 'SAL-20240103-0003',
                'customer_name' => 'Alice Brown',
                'customer_phone' => '+1-555-222-3333',
                'products' => json_encode([
                    ['product_id' => 4, 'name' => 'Smart Fitness Band', 'quantity' => 1, 'price' => 60, 'subtotal' => 60],
                    ['product_id' => 5, 'name' => 'Noise Cancelling Earbuds', 'quantity' => 1, 'price' => 150, 'subtotal' => 150],
                ]),
                'total_amount' => 210,
                'vat' => 18.8,
                'discount' => 10,
                'grand_total' => 218.8,
                'paid_by' => 'mobile',
                'created_at' => Carbon::parse('2024-01-03'),
                'updated_at' => Carbon::parse('2024-01-03'),
            ],
            [
                'sales_id' => 'SAL-20240104-0004',
                'customer_name' => 'Bob Johnson',
                'customer_phone' => '+1-555-444-5555',
                'products' => json_encode([
                    ['product_id' => 6, 'name' => 'Portable SSD', 'quantity' => 2, 'price' => 80, 'subtotal' => 160],
                ]),
                'total_amount' => 160,
                'vat' => 12.5,
                'discount' => 15,
                'grand_total' => 157.5,
                'paid_by' => 'cash',
                'created_at' => Carbon::parse('2024-01-04'),
                'updated_at' => Carbon::parse('2024-01-04'),
            ],
            [
                'sales_id' => 'SAL-20240105-0005',
                'customer_name' => 'Sara Lee',
                'customer_phone' => '+1-555-777-8888',
                'products' => json_encode([
                    ['product_id' => 7, 'name' => 'Bluetooth Speaker', 'quantity' => 1, 'price' => 55.75, 'subtotal' => 55.75],
                    ['product_id' => 8, 'name' => 'Smart Watch', 'quantity' => 1, 'price' => 220, 'subtotal' => 220],
                ]),
                'total_amount' => 275.75,
                'vat' => 18.5,
                'discount' => 20,
                'grand_total' => 274.25,
                'paid_by' => 'card',
                'created_at' => Carbon::parse('2024-01-05'),
                'updated_at' => Carbon::parse('2024-01-05'),
            ],
            [
                'sales_id' => 'SAL-20240106-0006',
                'customer_name' => 'Michael King',
                'customer_phone' => '+1-555-888-9999',
                'products' => json_encode([
                    ['product_id' => 9, 'name' => 'Wireless Mouse', 'quantity' => 2, 'price' => 40, 'subtotal' => 80],
                ]),
                'total_amount' => 80,
                'vat' => 6.40,
                'discount' => 3,
                'grand_total' => 83.4,
                'paid_by' => 'mobile',
                'created_at' => Carbon::parse('2024-01-06'),
                'updated_at' => Carbon::parse('2024-01-06'),
            ],
            [
                'sales_id' => 'SAL-20240107-0007',
                'customer_name' => 'Emily Turner',
                'customer_phone' => '+1-555-101-2020',
                'products' => json_encode([
                    ['product_id' => 10, 'name' => 'Gaming Keyboard', 'quantity' => 1, 'price' => 90, 'subtotal' => 90],
                    ['product_id' => 11, 'name' => 'HD Webcam', 'quantity' => 1, 'price' => 70, 'subtotal' => 70],
                ]),
                'total_amount' => 160,
                'vat' => 14.0,
                'discount' => 7,
                'grand_total' => 167,
                'paid_by' => 'card',
                'created_at' => Carbon::parse('2024-01-07'),
                'updated_at' => Carbon::parse('2024-01-07'),
            ],
            [
                'sales_id' => 'SAL-20240108-0008',
                'customer_name' => 'Victor Fox',
                'customer_phone' => '+1-555-303-4040',
                'products' => json_encode([
                    ['product_id' => 12, 'name' => 'Laptop Stand', 'quantity' => 2, 'price' => 27.50, 'subtotal' => 55],
                ]),
                'total_amount' => 55,
                'vat' => 4.4,
                'discount' => 2,
                'grand_total' => 57.4,
                'paid_by' => 'cash',
                'created_at' => Carbon::parse('2024-01-08'),
                'updated_at' => Carbon::parse('2024-01-08'),
            ],
            [
                'sales_id' => 'SAL-20240109-0009',
                'customer_name' => 'Lily Adams',
                'customer_phone' => '+1-555-505-6060',
                'products' => json_encode([
                    ['product_id' => 13, 'name' => 'USB Type-C Cable', 'quantity' => 5, 'price' => 15, 'subtotal' => 75],
                ]),
                'total_amount' => 75,
                'vat' => 5.2,
                'discount' => 2.5,
                'grand_total' => 77.7,
                'paid_by' => 'mobile',
                'created_at' => Carbon::parse('2024-01-09'),
                'updated_at' => Carbon::parse('2024-01-09'),
            ],
            [
                'sales_id' => 'SAL-20240110-0010',
                'customer_name' => 'Chris Moore',
                'customer_phone' => '+1-555-707-8080',
                'products' => json_encode([
                    ['product_id' => 14, 'name' => 'Wireless Router', 'quantity' => 1, 'price' => 100, 'subtotal' => 100],
                    ['product_id' => 15, 'name' => 'Smart Bulb', 'quantity' => 2, 'price' => 30, 'subtotal' => 60],
                ]),
                'total_amount' => 160,
                'vat' => 13,
                'discount' => 8,
                'grand_total' => 165,
                'paid_by' => 'card',
                'created_at' => Carbon::parse('2024-01-10'),
                'updated_at' => Carbon::parse('2024-01-10'),
            ],
        ];

        foreach ($salesData as $data) {
            Sales::create($data);
        }
    }
}
